unit Unit2; //  ""

interface

type

Point3d = record    //  
  x,y,z : extended; // 
  x2d,y2d :Integer; //  
end;

TPoint3d = ^Point3d; // -   

Triangle = record  //  
  A,B,C: TPoint3d; //    
  normal: TPoint3d; //  ;
end;

TTriangle = ^Triangle; //  ""

Figure = class
 public
    shading: byte;           //  
    midpoint :Point3d;       //   
    points: array of TPoint3d; //  , ,  
    normals: array of TPoint3d;
    polys: array of TTriangle;
    numPoints, numNormals, numFaces: Longword;//
                                            //, , 
    constructor FigureCreate(FileName: string);
    destructor FigureDestroy;
    //  
    procedure RotateAboutPoint(X, Y, Z, angleX, angleY, angleZ: extended);
    //   
    procedure RotateWorldCoord(angleX, angleY, angleZ: extended);
    //
    procedure Translate(dX, dY, dZ: extended);
    //
    procedure Scale(sX, sY, sZ: extended);
    //     
    procedure TransformToScreen;
    // 
    procedure ShowFigure;

private
    procedure SetMidPoint;//   
    procedure CalcNormal(N: Longword);// 
    procedure LoadObject(FileName: string); //  
    procedure Wire; //   
    procedure Varnok; //   
end;

function SubVec(V1,V2: Point3d):Point3d; //  
procedure Normalize (V: TPoint3d); //  (  1)

implementation

uses Unit1;

//---------------------------------------------------------------------------
function SubVec(V1,V2: Point3d):Point3d;
begin
   Result.x := V1.x - V2.x;
   Result.y := V1.y - V2.y;
   Result.z := V1.z - V2.z;
end;
//---------------------------------------------------------------------------
procedure Normalize (V: TPoint3d);
 var
   length: extended;
begin
   length := sqrt((V^.x * V^.x) + (V^.y * V^.y) + (V^.z * V^.z));
   V^.x := V^.x/length;
   V^.y := V^.y/length;
   V^.z := V^.z/length;
end;
//---------------------------------------------------------------------------

constructor Figure.FigureCreate(FileName: string);
begin
   numPoints := 0;
   numNormals := 0;
   numFaces := 0;
   LoadObject(FileName);
end;

destructor Figure.FigureDestroy;
 var
  count: Longword;
begin
  for count:=0 to (numPoints-1) do
   dispose(points[count]);
  points := nil;
  for count:=0 to (numNormals-1) do
   dispose(normals[count]);
  normals := nil;
  for count:=0 to (numFaces-1) do
   dispose(polys[count]);
  polys := nil;
end;

procedure Figure.SetMidPoint;
 var
   count: Integer;
   tmpX,tmpY,tmpZ: extended;
begin
   tmpX:=0;
   tmpY:=0;
   tmpZ:=0;
   for count:=0 to (numPoints-1) do
   begin
   	tmpX := tmpX + points[count]^.x;
   	tmpY := tmpY + points[count]^.y;
   	tmpZ := tmpZ + points[count]^.z;
   end;
   tmpX := tmpX/numPoints;
   tmpY := tmpY/numPoints;
   tmpZ := tmpZ/numPoints;

   midpoint.x := tmpX;
   midpoint.y := tmpY;
   midpoint.z := tmpZ;
end;

procedure Figure.CalcNormal(N: Longword);
 var
   Vector1: array [0..2] of extended;
   Vector2: array [0..2] of extended;
   nx,ny,nz,l: extended;
begin
   Vector1[0]:= polys[N]^.B^.x - polys[N]^.A^.x;//  2   
   Vector2[0]:= polys[N]^.C^.x - polys[N]^.A^.x;
   Vector1[1]:= polys[N]^.B^.y - polys[N]^.A^.y;
   Vector2[1]:= polys[N]^.C^.y - polys[N]^.A^.y;
   Vector1[2]:= polys[N]^.B^.z - polys[N]^.A^.z;
   Vector2[2]:= polys[N]^.C^.z - polys[N]^.A^.z;

   nx := Vector1[2]*Vector2[1] - Vector1[1]*Vector2[2];
   ny := Vector1[0]*Vector2[2] - Vector1[2]*Vector2[0];
   nz := Vector1[1]*Vector2[0] - Vector1[0]*Vector2[1];

   l:=sqrt((nx * nx) + (ny * ny) + (nz * nz));
   if (l<>0) then
   begin
     nx := nx/l;
     ny := ny/l;
     nz := nz/l;
   end;

   new(normals[N]);
   normals[N]^.x := nx;
   normals[N]^.y := ny;
   normals[N]^.z := nz;
   polys[N]^.normal := normals[N];
end;

procedure Figure.LoadObject(FileName: string);
 var
   f: Text;
   str: string;
   Znach :string;
   Vertices, Faces: Longword;
   count, A, B, C: Longword;
   X, Y, Z: extended;
   Code: Integer;
   n1,n2: byte;
begin
  Assign(f,FileName);
  Reset(f);

  while (not EOF(f)) do
  begin
    Readln(f,str);

    if(Pos('Tri-mesh',str)<>0) then
    begin
      n1:=21;
      n2:=Pos('Faces',str);
      n2:=n2-5;
      Znach:=Copy(str,n1,n2-n1);
      Val(Znach,Vertices,Code);
      n1:=n2+5+7;
      n2:=Length(str)+1;
      Znach:=Copy(str,n1,n2-n1);
      Val(Znach,Faces,Code);
      numPoints := Vertices;
      numNormals := Faces;
      numFaces := Faces;
      SetLength(points,Vertices);
      SetLength(normals,Faces);
      SetLength(polys,Faces);

      Readln(f,str);  // "Vertex list:"
      if (Pos('Mapped',str)<>0) then Readln(f,str);

      for count:=0 to (Vertices-1) do
      begin
        Readln(f,str);
        n1:=Pos('X:',str)+2;
        n2:=Pos('Y:',str)-5;
        Znach:=Copy(str,n1,n2-n1);
        Val(Znach,X,Code);

        n1:=Pos('Y:',str)+2;
        n2:=Pos('Z:',str)-5;
        Znach:=Copy(str,n1,n2-n1);
        Val(Znach,Y,Code);

        n1:=Pos('Z:',str)+2;
        if (Pos('U:',str)=0) then
         n2:=Length(str)+1
        else
         n2:=Pos('U:',str)-5;
        Znach:=Copy(str,n1,n2-n1);
        Val(Znach,Z,Code);
        new(points[count]);
        points[count]^.x:=X;
        points[count]^.y:=Z; //3dMax
        points[count]^.z:=Y;
      end;

      Readln(f,str); // "Face list:"

      Readln(f,str);

      for count:=0 to (Faces-1) do
      begin
        while Pos('Face',str)=0 do Readln(f,str);
        n1:=Pos('A:',str)+2;
        n2:=Pos('B:',str)-1;
        Znach:=Copy(str,n1,n2-n1);
        Val(Znach,A,Code);

        n1:=Pos('B:',str)+2;
        n2:=Pos('C:',str)-1;
        Znach:=Copy(str,n1,n2-n1);
        Val(Znach,B,Code);

        n1:=Pos('C:',str)+2;
        n2:=Pos('AB:',str)-1;
        Znach:=Copy(str,n1,n2-n1);
        Val(Znach,C,Code);
        new(polys[count]);
        polys[count]^.A:=points[A];
        polys[count]^.B:=points[B];
        polys[count]^.C:=points[C];
        CalcNormal(count);
        Readln(f,str);
      end;
      shading:=1;
      SetMidPoint;
      break;
    end;
  end;
  Close(f);
end;

procedure Figure.RotateAboutPoint(X, Y, Z, angleX, angleY, angleZ: extended);
 var
  sinx,cosx,siny,cosy,sinz,cosz: extended;
  coordX,coordY,coordZ: extended;
  tX,tY,tZ: extended;
  count: Longword;
begin
   sinx := Sin(angleX * PI / 180.0); //     
   cosx := Cos(angleX * PI / 180.0);
   siny := Sin(angleY * PI / 180.0);
   cosy := Cos(angleY * PI / 180.0);
   sinz := Sin(angleZ * PI / 180.0);
   cosz := Cos(angleZ * PI / 180.0);

   coordX := midpoint.x - X;   //  
   coordY := midpoint.y - Y;
   coordZ := midpoint.z - Z;
   tX := (coordX * cosz - coordY * sinz);// Z
   tY := (coordX * sinz + coordY * cosz);
   tZ := coordZ;
   coordY := (tY * cosx - tZ * sinx);// X
   coordZ := (tY * sinx + tZ * cosx);
   tZ := coordZ;
   coordX := (tZ * siny + tX * cosy);// Y
   coordZ := (tZ * cosy - tX * siny);
   midpoint.x := coordX + X;
   midpoint.y := coordY + Y;
   midpoint.z := coordZ + Z;

   for count:=0 to (numPoints-1) do
   begin
      coordX := points[count]^.x - X;
      coordY := points[count]^.y - Y;
      coordZ := points[count]^.z - Z;

      tX := (coordX * cosz - coordY * sinz);// Z
      tY := (coordX * sinz + coordY * cosz);
      tZ := coordZ;
      coordY := (tY * cosx - tZ * sinx);// X
      coordZ := (tY * sinx + tZ * cosx);
      tZ := coordZ;
      coordX := (tZ * siny + tX * cosy);// Y
      coordZ := (tZ * cosy - tX * siny);

      points[count]^.x := coordX + X;
      points[count]^.y := coordY + Y;
      points[count]^.z := coordZ + Z;
   end;

   for count:=0 to (numNormals-1) do
   begin
      coordX := normals[count]^.x;
      coordY := normals[count]^.y;
      coordZ := normals[count]^.z;

      tX := (coordX * cosz - coordY * sinz);// Z
      tY := (coordX * sinz + coordY * cosz);
      tZ := coordZ;
      coordY := (tY * cosx - tZ * sinx);// X
      coordZ := (tY * sinx + tZ * cosx);
      tZ := coordZ;
      coordX := (tZ * siny + tX * cosy);// Y
      coordZ := (tZ * cosy - tX * siny);

      normals[count]^.x := coordX;
      normals[count]^.y := coordY;
      normals[count]^.z := coordZ;
   end;
end;

procedure Figure.RotateWorldCoord(angleX, angleY, angleZ: extended);
begin
   RotateAboutPoint(0,0,0,angleX,angleY,angleZ);
end;

procedure Figure.Translate(dX, dY, dZ: extended);
 var
  count: Longword;
begin
   for count:=0 to (numPoints-1) do
   begin
      points[count]^.x:=points[count]^.x+dX;
      points[count]^.y:=points[count]^.y+dY;
      points[count]^.z:=points[count]^.z+dZ;
   end;
end;

procedure Figure.Scale(sX, sY, sZ: extended);
 var
  count: Longword;
  coordX,coordY,coordZ: extended;
begin
   for count:=0 to (numPoints-1) do
   begin
      coordX := points[count]^.x - midpoint.x;
      coordY := points[count]^.y - midpoint.y;
      coordZ := points[count]^.z - midpoint.z;

      coordX := coordX*sX;
      coordY := coordY*sY;
      coordZ := coordZ*sZ;

      points[count]^.x := coordX + midpoint.x;
      points[count]^.y := coordY + midpoint.y;
      points[count]^.z := coordZ + midpoint.z;
   end;
end;

procedure Figure.TransformToScreen;
 var
  count: Longword;
begin
  for count:=0 to (numPoints-1) do
  begin
     points[count]^.x2d := Round(points[count]^.x) + MidX;
     points[count]^.y2d := MidY - Round(points[count]^.y);
  end;
end;

procedure Figure.ShowFigure;
begin

  TransformToScreen();
  case shading of
    1: Wire;
    2: Varnok;
  end;
end;

procedure Figure.Wire;
 var
  count : Longword;
begin
  for count:=0 to (numFaces-1) do
  begin
    Line(polys[count]^.A,polys[count]^.B);
    Line(polys[count]^.B,polys[count]^.C);
    Line(polys[count]^.C,polys[count]^.A);
  end;
end;
////////////////////////////////////////////////////////////////////////////////

type
  Window = record
    x,y,size:Longint;
  end;

var
  Stack: array of ^Window;
  Counter: Longword=0;

  Xmin: array of Longint;
  Xmax: array of Longint;
  Ymin: array of Longint;
  Ymax: array of Longint;

procedure Push(X,Y,SIZE: Longword);
begin
  SetLength(Stack,Counter+1);
  new(Stack[Counter]);
  Stack[Counter]^.x:=X;
  Stack[Counter]^.y:=Y;
  Stack[Counter]^.size:=SIZE;
  inc(Counter);
end;

procedure Pop(var X: Longint;var Y: Longint;var SIZE: Longint);
begin
  if (Counter-1)<0 then exit;
  X:=Stack[Counter-1]^.x;
  Y:=Stack[Counter-1]^.y;
  SIZE:=Stack[Counter-1]^.size;
  dispose(Stack[Counter-1]);
  SetLength(Stack,Counter-1);
  dec(Counter);
end;

function simple_triangle_Test(N,X,Y,SIZE: Longint):boolean;
 var
   Xleft,Xright,Ybottom,Ytop: Longint;
begin

   Xleft := X;
   Xright := X+SIZE-1;
   Ytop := Y;
   Ybottom := Y+SIZE-1;

   if (Xmin[N]>Xright) then begin simple_triangle_Test:=false; exit; end;
   if (Xmax[N]<Xleft) then begin simple_triangle_Test:=false; exit; end;
   if (Ymax[N]<Ytop) then begin simple_triangle_Test:=false; exit; end;
   if (Ymin[N]>Ybottom) then begin simple_triangle_Test:=false; exit; end;

   simple_triangle_Test:=true;
end;

function ZDepth(X,Y:Longword; tP:TTriangle):extended;
 type
  fpoint = record
    x,y,z: extended;
  end;
 var
  PX,PY:extended;
  p,q: fpoint; //vectors
  n: fpoint; //normal
  cc: extended;
  A,B,C: TPoint3d;
begin
  A := tP^.A;
  B := tP^.B;
  C := tP^.C;

  p.x := B^.x2d-A^.x2d;//1
  p.y := B^.y2d-A^.y2d;
  p.z := B^.z-A^.z;
  q.x := C^.x2d-A^.x2d;//2
  q.y := C^.y2d-A^.y2d;
  q.z := C^.z-A^.z;

  n.z := p.x*q.y-p.y*q.x;
  n.x := p.y*q.z-p.z*q.y;
  n.y := -(p.x*q.z-p.z*q.x);

  cc := n.x*A^.x2d+n.y*A^.y2d+n.z*A^.z;

  PX:=X+0.5;
  PY:=Y+0.5;

  Zdepth := (cc - n.x*PX - n.y*PY)/n.z;
end;


function in_Window(X,Y: Longword; P: array of TTriangle; N:Longword):Longint;
 var
  Zmin: extended;
  Z: extended;
  A,B,C: TPoint3d;
  AB,BC,CA,AD,BD,CD: Point3d;
  D: Point3d;
  f1,f2,f3: extended;
  s1,s2,s3,s4: extended;
  i:Longint;

begin
  in_Window:=-1;
  Zmin:= 10000000;
  for i:=0 to (N-1) do
  begin
     A := P[i]^.A;
     B := P[i]^.B;
     C := P[i]^.C;

     if ((A^.y2d = B^.y2d)and(A^.y2d = C^.y2d)) then continue;
     if ((A^.x2d = B^.x2d)and(A^.x2d = C^.x2d)) then continue;

  D.x := X;
  D.y := Y;

     AB.x := B^.x2d - A^.x2d;
     AB.y := B^.y2d - A^.y2d;
     BC.x := C^.x2d - B^.x2d;
     BC.y := C^.y2d - B^.y2d;
     CA.x := A^.x2d - C^.x2d;
     CA.y := A^.y2d - C^.y2d;

     AD.x := D.x - A^.x2d;
     AD.y := D.y - A^.y2d;
     BD.x := D.x - B^.x2d;
     BD.y := D.y - B^.y2d;
     CD.x := D.x - C^.x2d;
     CD.y := D.y - C^.y2d;

     f1 := AB.x*AD.y - AD.x*AB.y;
     f2 := BC.x*BD.y - BD.x*BC.y;
     f3 := CA.x*CD.y - CD.x*CA.y;
     if ( (f1<0)and(f2<0)and(f3<0) ) then s1 := -1 else s1 := 1;
     if ((f1=0)and(f2<=0)and(f3<=0)) then s1 := 0;
     if ((f2=0)and(f1<=0)and(f3<=0)) then s1 := 0;
     if ((f3=0)and(f1<=0)and(f2<=0)) then s1 := 0;

  D.x := X+1;
  D.y := Y;

     AD.x := D.x - A^.x2d;
     AD.y := D.y - A^.y2d;
     BD.x := D.x - B^.x2d;
     BD.y := D.y - B^.y2d;
     CD.x := D.x - C^.x2d;
     CD.y := D.y - C^.y2d;

     f1 := AB.x*AD.y - AD.x*AB.y;
     f2 := BC.x*BD.y - BD.x*BC.y;
     f3 := CA.x*CD.y - CD.x*CA.y;
     if ( (f1<0)and(f2<0)and(f3<0) ) then s2 := -1 else s2 := 1;
     if ((f1=0)and(f2<=0)and(f3<=0)) then s2 := 0;
     if ((f2=0)and(f1<=0)and(f3<=0)) then s2 := 0;
     if ((f3=0)and(f1<=0)and(f2<=0)) then s2 := 0;


  D.x := X;
  D.y := Y+1;

     AD.x := D.x - A^.x2d;
     AD.y := D.y - A^.y2d;
     BD.x := D.x - B^.x2d;
     BD.y := D.y - B^.y2d;
     CD.x := D.x - C^.x2d;
     CD.y := D.y - C^.y2d;

     f1 := AB.x*AD.y - AD.x*AB.y;
     f2 := BC.x*BD.y - BD.x*BC.y;
     f3 := CA.x*CD.y - CD.x*CA.y;
     if ( (f1<0)and(f2<0)and(f3<0) ) then s3 := -1 else s3 := 1;
     if ((f1=0)and(f2<=0)and(f3<=0)) then s3 := 0;
     if ((f2=0)and(f1<=0)and(f3<=0)) then s3 := 0;
     if ((f3=0)and(f1<=0)and(f2<=0)) then s3 := 0;


  D.x := X+1;
  D.y := Y+1;

     AD.x := D.x - A^.x2d;
     AD.y := D.y - A^.y2d;
     BD.x := D.x - B^.x2d;
     BD.y := D.y - B^.y2d;
     CD.x := D.x - C^.x2d;
     CD.y := D.y - C^.y2d;

     f1 := AB.x*AD.y - AD.x*AB.y;
     f2 := BC.x*BD.y - BD.x*BC.y;
     f3 := CA.x*CD.y - CD.x*CA.y;
     if ( (f1<0)and(f2<0)and(f3<0) ) then s4 := -1 else s4 := 1;
     if ((f1=0)and(f2<=0)and(f3<=0)) then s4 := 0;
     if ((f2=0)and(f1<=0)and(f3<=0)) then s4 := 0;
     if ((f3=0)and(f1<=0)and(f2<=0)) then s4 := 0;

     if ( (s1<0)and(s2<0)and(s3<0)and(s4<0) ) then
     begin
       Z := ZDepth(X,Y,P[i]);
       if (Z<Zmin) then
       begin
         Zmin := Z;
         in_window := foncolor;
       end;
       continue;
     end
     else
     if ( ((s1=0)and(s3=0))or((s1=0)and(s2=0)) ) then
     begin
       Z := ZDepth(X,Y,P[i]);
       if (Z<Zmin) then
       begin
         Zmin := Z;
         in_window := objcolor;
       end;
       continue;
     end
     else
     if ( ((s2=0)and(s4=0))or((s3=0)and(s4=0)) ) then
     else
     if ( not((s1>=0)and(s2>=0)and(s3>=0)and(s4>=0)) ) then
     begin
       Z := ZDepth(X,Y,P[i]);
       if (Z<Zmin) then
       begin
         Zmin := Z;
         in_window := objcolor;
       end;
       continue;
     end;
  end;
end;


procedure Figure.Varnok;
 var
  x,y,size:Longint;
  flag: boolean;
  V1: TPoint3d;
  V2: Point3d;
  ugol: extended;
  num,count : Longint;
  polylst: array of TTriangle;
  A,B,C:TPoint3d;
  color: Longint;
  
begin
  V2.x:=0;
  V2.y:=0;
  V2.z:=-1;
  num:=0;
  for count:=0 to (numFaces-1) do
  begin
    V1 := polys[count]^.normal;
    ugol:= V1^.x*V2.x + V1^.y*V2.y + V1^.z*V2.z;
    if (ugol>0) then
    begin
      inc(num);
      SetLength(polylst,num);
      polylst[num-1] := polys[count];
    end;
  end;
  SetLength(Xmin,num);
  SetLength(Xmax,num);
  SetLength(Ymin,num);
  SetLength(Ymax,num);
  for count:=0 to (num-1) do
  begin
    A:=polylst[count]^.A;
    B:=polylst[count]^.B;
    C:=polylst[count]^.C;
    if (A^.x2d<B^.x2d) then Xmin[count] := A^.x2d
    else Xmin[count] := B^.x2d;
    if (Xmin[count]>C^.x2d) then Xmin[count] := C^.x2d;

    if (A^.x2d>B^.x2d) then Xmax[count] := A^.x2d
    else Xmax[count] := B^.x2d;
    if (Xmax[count]<C^.x2d) then Xmax[count] := C^.x2d;

    if (A^.y2d<B^.y2d) then Ymin[count] := A^.y2d
    else Ymin[count] := B^.y2d;
    if (Ymin[count]>C^.y2d) then Ymin[count] := C^.y2d;

    if (A^.y2d>B^.y2d) then Ymax[count] := A^.y2d
    else Ymax[count] := B^.y2d;
    if (Ymax[count]<C^.y2d) then Ymax[count] := C^.y2d;
  end;

  Push(0,0,1024);

  while (Counter>0) do
  begin
    Pop(x,y,size);
    flag:=false;
    for count:=0 to (num-1) do
      if (simple_triangle_Test(count,x,y,size)) then
      begin
        flag:=true;
        break;
      end;
    if (flag) then
    begin
      if (size>1) then
      begin
        size := size div 2;
        Push(x+size,y+size,size);
        Push(x,y+size,size);
        Push(x+size,y,size);
        Push(x,y,size);
      end //if size
      else
      begin
         color:=in_Window(x,y,polylst,num);
         if (color>=0) then
         begin
           SetPoint(x,y,color);
         end;
      end;
    end;
  end;
  SetLength(polylst,0);
  SetLength(Xmin,0);
  SetLength(Xmax,0);
  SetLength(Ymin,0);
  SetLength(Ymax,0);
end;


end.
