unit Unit1;  // 
             //        
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ExtCtrls, Unit2;

type
  TForm1 = class(TForm)   // 
    PaintBox1: TPaintBox; //  
    MainMenu1: TMainMenu; // 
    File1: TMenuItem;
    About1: TMenuItem; //  " "
    OpenAscFile1: TMenuItem; // " "
    Exit1: TMenuItem; // ""
    Options1: TMenuItem;
    Rotate1: TMenuItem;  // ""
    Change1: TMenuItem;  //  
    ChangeObjectColor1: TMenuItem; //  
    ColorDialog1: TColorDialog; //   
    N1: TMenuItem;
    N2: TMenuItem; //    ""
    N3: TMenuItem; //    ""
    OpenDialog1: TOpenDialog; //   
    N4: TMenuItem; // ""
    N5: TMenuItem; // 
    procedure FormCreate(Sender: TObject); //    . 
    procedure PaintBox1Paint(Sender: TObject);//  
    procedure Change1Click(Sender: TObject);
    procedure ChangeObjectColor1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);//   
    procedure Rotate1Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure OpenAscFile1Click(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure N5Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    { Private declarations }
  public
    procedure ClearScreen(); //  
    { Public declarations }
  end;

var
  Form1: TForm1; //  

  Figure1: Figure;//  ""

  MidX: Integer ;//  
  MidY: Integer;
  SWidth: Integer;//   
  SHeight: Integer;

  foncolor: Longword;//   
  objcolor: Longword;

procedure Line(p1,p2 : TPoint3d);  // 
procedure SetPoint(X, Y, Color: Longint); // 

implementation

uses Unit3, Unit4, Unit5, Unit6;

{$R *.dfm}

procedure Line(p1,p2 : TPoint3d);
begin
   Form1.PaintBox1.Canvas.Pen.Color := objcolor;
   Form1.PaintBox1.Canvas.MoveTo(p1^.x2d,p1^.y2d);
   Form1.PaintBox1.Canvas.LineTo(p2^.x2d,p2^.y2d);
end;

procedure SetPoint(X, Y, Color: Longint);
begin
   if ( (X>=0) and (X<SWidth) and (Y>=0) and (Y<SHeight) )  then
     Form1.PaintBox1.Canvas.Pixels[x,y] := Color;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   foncolor:=RGB(255,255,255);  //    
   objcolor:=RGB(0,0,0);        //  - 
   ClearScreen();               // 
end;

procedure TForm1.ClearScreen();
begin
   Form1.PaintBox1.Canvas.Pen.Color := foncolor;
   Form1.PaintBox1.Canvas.Brush.Color:=foncolor;
   Form1.PaintBox1.Canvas.Brush.Style:=bsSolid;
   Form1.PaintBox1.Canvas.Rectangle(0,0,Width,Height);
end;


procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
   SWidth := PaintBox1.Width;
   SHeight := PaintBox1.Height;
   MidX := Round(SWidth/2);
   MidY := Round(SHeight/2);
   ClearScreen();
   if (Figure1<>nil) then Figure1.ShowFigure;  //   
end;

procedure TForm1.Change1Click(Sender: TObject);
begin
   if (ColorDialog1.Execute()) then foncolor:=ColorDialog1.Color; //   
   PaintBox1Paint(Sender);
end;

procedure TForm1.ChangeObjectColor1Click(Sender: TObject);
begin
   if (ColorDialog1.Execute()) then objcolor:=ColorDialog1.Color;
   PaintBox1Paint(Sender);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if (Figure1<>nil) then Figure1.FigureDestroy;  //   
end;


procedure TForm1.Rotate1Click(Sender: TObject);
begin
 OKBottomDlg.ShowModal; //   (..      
end;                                             //   

procedure TForm1.N2Click(Sender: TObject);
begin                       //    
 if (N2.Checked=false) then
  begin
    N3.Checked := false;
    N2.Checked := true;
    Figure1.shading:=1;    //   
    PaintBox1Paint(Sender);
  end;
end;

procedure TForm1.N3Click(Sender: TObject);
begin                       //    
 if (N3.Checked=false) then
  begin
    N2.Checked := false;
    N3.Checked := true;
    Figure1.shading:=2;    // 
    PaintBox1Paint(Sender);
  end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.OpenAscFile1Click(Sender: TObject);
 var              //  ASCII 
  s:string;
  ss:AnsiString;
begin
   setlength(ss,1000);
   GetCurrentDirectory(1000,PChar(ss));
   OpenDialog1.InitialDir:=ss; //     - 
   if (OpenDialog1.Execute=true) then
   begin
    Sc:=1;
    N2.Checked:=true;
    N3.Checked:=false;
    s:=OpenDialog1.FileName;
    if (Figure1<>nil) then Figure1.FigureDestroy; //     
    Figure1 :=Figure.FigureCreate(s); //   
    Options1.Enabled:=true; //    
    PaintBox1Paint(Sender);
   end;
end;

procedure TForm1.N4Click(Sender: TObject);
begin
 Form4.ShowModal; //  ""
end;

procedure TForm1.N5Click(Sender: TObject);
begin
 Form5.ShowModal; //  ""
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal; //   " "
end;

end.
